import React from 'react';

import {IIconProps} from 'icons/types/icon';

import IPrice from 'utilities/currency/PriceInterface';

import Link from 'components/Link/Link';
import Flex from 'components/Flex/Flex';
import Price from 'components/Price/Price';

import cx from './LinksListItem.scss';

interface ILinkProps {
    url: string;
    target?: string;
    rel?: string;
}

export interface ILinksListItem {
    link: ILinkProps;
    text: string;
    price?: IPrice;
    priceAsLink?: boolean;
    icon?: React.ComponentType<IIconProps>;
    onLinkClick?(): void;
}

const LinksListItem: React.FC<ILinksListItem> = props => {
    const {link, text, price, icon: Icon, priceAsLink, onLinkClick} = props;

    return (
        <Flex justifyContent="space-between" inline nowrap between="4">
            {priceAsLink ? (
                <>
                    <Flex inline textSize="l" nowrap>
                        {Icon && <Icon className={cx('icon')} />}
                        {text}
                    </Flex>

                    {price && (
                        <Link {...link} onClick={onLinkClick}>
                            <Price className={cx('price')} isFrom {...price} />
                        </Link>
                    )}
                </>
            ) : (
                <>
                    <Link {...link} onClick={onLinkClick}>
                        <Flex inline textSize="l" nowrap>
                            {Icon && <Icon className={cx('icon')} />}
                            {text}
                        </Flex>
                    </Link>

                    {price && (
                        <Price className={cx('price')} isFrom {...price} />
                    )}
                </>
            )}
        </Flex>
    );
};

export default LinksListItem;
