import {Meta} from '@storybook/react/types-6-0';
import {ReactNode} from 'react';
import times from 'lodash/times';

import {TStorybookFunctionComponent} from 'storybook/types';

import Menu from 'components/Menu/Menu';
import MenuItem from 'components/MenuItem/MenuItem';
import CheckButton from 'components/CheckButton/CheckButton';
import Dropdown from 'components/Dropdown/Dropdown';
import Text from 'components/Text/Text';
import Separator from 'components/Separator/Separator';

export default {
    title: 'Example/Menu',
    component: Menu,
} as Meta;

const MANY_OPTIONS = times(1000);

export const Simple: TStorybookFunctionComponent = () => (
    <Menu>
        <MenuItem value="a">Каждый</MenuItem>
        <MenuItem value="b">Охотник</MenuItem>
        <MenuItem value="c">Желает</MenuItem>
        <MenuItem value="d">Знать</MenuItem>
        <Separator margin={2} />
        <MenuItem value="e" disabled>
            Где
        </MenuItem>
        <MenuItem value="f">Сидит</MenuItem>
        <MenuItem value="g">Фазан</MenuItem>
    </Menu>
);

export const Styled: TStorybookFunctionComponent = () => (
    <Menu initialFocusedName="c">
        <StyledMenuItem value="a" label="Каждый" />
        <StyledMenuItem value="b" label="Охотник" />
        <StyledMenuItem value="c" label="Желает" />
        <StyledMenuItem value="d" label="Знать" />
        <Separator margin={2} />
        <StyledMenuItem value="e" label="Каждый" />
        <StyledMenuItem value="f" label="Сидит" />
        <StyledMenuItem value="g" label="Фазан" />
    </Menu>
);

export const SelectableWithIcon: TStorybookFunctionComponent = () => (
    <Menu>
        <MenuItem value="a" enableSelectedIcon>
            Каждый
        </MenuItem>
        <MenuItem value="b" enableSelectedIcon>
            Охотник
        </MenuItem>
        <MenuItem value="c" enableSelectedIcon selected>
            Желает
        </MenuItem>
        <MenuItem value="d" enableSelectedIcon>
            Знать
        </MenuItem>
        <Separator margin={2} />
        <MenuItem value="e" disabled enableSelectedIcon>
            Где
        </MenuItem>
        <MenuItem value="f" enableSelectedIcon>
            Сидит
        </MenuItem>
        <MenuItem value="g" enableSelectedIcon>
            Фазан
        </MenuItem>
    </Menu>
);

export const WithDropdown: TStorybookFunctionComponent = () => (
    <Dropdown
        renderSwitcher={({
            input: {ref},
            meta: {visible, hidePopup, showPopup},
        }): ReactNode => (
            <CheckButton
                checked={visible}
                onClick={visible ? hidePopup : showPopup}
                innerRef={ref}
            >
                Справочник путешественника
            </CheckButton>
        )}
        renderPopup={({meta: {hidePopup}}): ReactNode => (
            <Menu onSelect={hidePopup}>
                <MenuItem value="a">Каждый</MenuItem>
                <MenuItem value="b">Охотник</MenuItem>
                <MenuItem value="c">Желает</MenuItem>
                <MenuItem value="d">Знать</MenuItem>
                <Separator margin={2} />
                <MenuItem value="e" disabled>
                    Где
                </MenuItem>
                <MenuItem value="f">Сидит</MenuItem>
                <MenuItem value="g">Фазан</MenuItem>
            </Menu>
        )}
        popupProps={{style: {width: 240, padding: 0}}}
    />
);

export const TooMuchItems: TStorybookFunctionComponent = () => (
    <Menu>
        {MANY_OPTIONS.map(key => (
            <MenuItem key={key} value={key}>
                Item #{key}
            </MenuItem>
        ))}
    </Menu>
);

function StyledMenuItem({label, value}: {label: string; value: string}) {
    return (
        <MenuItem value={value}>
            <div>
                <div>
                    <Text size="m">{label}</Text>
                </div>
                <Text size="s">Value: {value}</Text>
            </div>
        </MenuItem>
    );
}
