import {FC, useMemo, useRef, useState} from 'react';
import noop from 'lodash/noop';

import {TMenuItemValue} from 'components/Menu/types';

import {getQa, IWithDataQaAttribute} from 'utilities/qaAttributes/qaAttributes';

import {IMenuContext, MenuContext} from 'components/Menu/Provider';

import cx from './Menu.scss';

export interface IMenuProps extends IWithDataQaAttribute {
    initialFocusedName?: string;
    onSelect?(value: TMenuItemValue): void;
}

const Menu: FC<IMenuProps> = ({
    children,
    initialFocusedName,
    onSelect = noop,
    ...props
}) => {
    const parentQa = getQa(props);
    const ref = useRef<HTMLDivElement>(null);
    const [focused, setFocused] = useState<TMenuItemValue | null>(
        initialFocusedName ?? null,
    );
    const context = useMemo<IMenuContext>(
        () => ({
            parentQa,
            focused,
            select: onSelect,
            focus: setFocused,
        }),
        [focused, onSelect, parentQa],
    );

    return (
        <div className={cx('root')} ref={ref} tabIndex={-1}>
            <MenuContext.Provider value={context}>
                {children}
            </MenuContext.Provider>
        </div>
    );
};

export default Menu;
