import {createContext} from 'react';
import noop from 'lodash/noop';

import {TMenuItemValue} from 'components/Menu/types';

import {TQaValue} from 'utilities/qaAttributes/qaAttributes';

export interface IMenuContext {
    parentQa?: TQaValue;
    focused: TMenuItemValue | null;
    select(value: TMenuItemValue): void;
    focus(value: TMenuItemValue): void;
}

export const MenuContext = createContext<IMenuContext>({
    focused: null,
    select: noop,
    focus: noop,
});
