import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BottomSheet, {
    IBottomSheetProps,
} from 'components/BottomSheet/BottomSheet';
import MessageBoxPopup, {
    IMessageBoxPopupProps,
} from 'components/MessageBoxPopup/MessageBoxPopup';

interface IMessageBoxPopupOrBottomSheetProps {
    children: React.ReactNode;
    isVisible: boolean;
    messageBoxProps?: Omit<
        IMessageBoxPopupProps,
        'children' | 'isVisible' | 'onClose'
    >;
    bottomSheetProps?: Omit<
        IBottomSheetProps,
        'children' | 'isOpened' | 'onClose'
    >;
    onClose?(e: React.MouseEvent<HTMLButtonElement, MouseEvent> | Event): void;
}

const MessageBoxPopupOrBottomSheet: React.FC<IMessageBoxPopupOrBottomSheetProps> =
    props => {
        const {
            children,
            isVisible,
            messageBoxProps,
            bottomSheetProps,
            onClose,
        } = props;
        const deviceType = useDeviceType();

        if (deviceType.isDesktop) {
            return (
                <MessageBoxPopup
                    {...messageBoxProps}
                    isVisible={isVisible}
                    onClose={onClose}
                >
                    {children}
                </MessageBoxPopup>
            );
        }

        return (
            <BottomSheet
                {...bottomSheetProps}
                isOpened={isVisible}
                onClose={onClose}
            >
                {children}
            </BottomSheet>
        );
    };

export default MessageBoxPopupOrBottomSheet;
