import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import MinLoaderTime from './MinLoaderTime';

export default {
    title: 'Example/MinLoaderTime',
    component: MinLoaderTime,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <MinLoaderTime
            componentNode={<div>Data is here!</div>}
            loaderNode={
                <div>Loading is shown for at least `minLoaderTime`...</div>
            }
            isLoaderNeeded={false}
            minLoaderTime={3000}
        />

        <MinLoaderTime
            componentNode={<div>Data is here!</div>}
            loaderNode={<div>Loading is forever...</div>}
            isLoaderNeeded={true}
            minLoaderTime={3000}
        />
    </>
);
