import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';

import ModalOrBottomSheet from './ModalOrBottomSheet';

export default {
    title: 'Example/ModalOrBottomSheet',
    component: ModalOrBottomSheet,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <>
            <Button onClick={(): void => setVisibility(true)}>Open</Button>
            <ModalOrBottomSheet
                isVisible={isVisible}
                onClose={(): void => setVisibility(false)}
            >
                Какое-то содержимое
            </ModalOrBottomSheet>
        </>
    );
};

Simple.parameters = {
    info: {
        title: 'Модальное окно или выезжающее окно снизу в зависимости от устройства',
    },
};
