import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import Button from 'components/Button/Button';

import ModalWithBackButton from './ModalWithBackButton';

export default {
    title: 'Example/ModalWithBackButton',
    component: ModalWithBackButton,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [isVisible, setVisibility] = useState(false);

    return (
        <>
            <Button onClick={(): void => setVisibility(true)}>Open</Button>
            <ModalWithBackButton
                backButtonText="Вернутся к оформлению заказу"
                onClose={(): void => setVisibility(false)}
                isVisible={isVisible}
                fullScreen
                canRenderBackButton
            >
                Modal content
            </ModalWithBackButton>
        </>
    );
};
