import React from 'react';
import _noop from 'lodash/noop';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/account';

import LinkButton from 'components/LinkButton/LinkButton';
import TextWithIcon from 'components/TextWithIcon/TextWithIcon';
import ArrowBackIcon from 'icons/16/ArrowBack';
import {TLinkThemeType} from 'components/Link/Link';

import cx from './Back.scss';

interface IBackProps extends IWithClassName, IWithQaAttributes {
    text?: string;
    fill?: string;
    onClick?: () => void;
    theme?: TLinkThemeType;
}

const Back: React.FC<IBackProps> = props => {
    const {
        className,
        text = i18nBlock.backDotDefault(),
        onClick = _noop,
        theme = 'normal',
    } = props;

    return (
        <LinkButton
            theme={theme}
            className={cx('root', className)}
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            <TextWithIcon
                size="m"
                spaceBetween="1"
                iconLeft={ArrowBackIcon}
                text={text}
            />
        </LinkButton>
    );
};

export default Back;
