import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import ModalWithTrigger from './ModalWithTrigger';

export default {
    title: 'Example/ModalWithTrigger',
    component: ModalWithTrigger,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <style
            dangerouslySetInnerHTML={{
                __html: `.modalTrigger {color: #0044bb; cursor: pointer;}`,
            }}
        />
        <ModalWithTrigger
            triggerClassName="modalTrigger"
            triggerText="Modal trigger"
        >
            <div
                style={{
                    minHeight: 100,
                    width: 1000,
                    backgroundColor: '#e6e6e6',
                    padding: '20px',
                }}
            >
                Modal content
            </div>
        </ModalWithTrigger>
    </>
);

export const CustomTrigger: TStorybookFunctionComponent = () => (
    <ModalWithTrigger
        renderTriggerNode={({onClick}): ReactNode => (
            <button onClick={onClick}> Button Text </button>
        )}
    >
        <div
            style={{
                minHeight: 100,
                width: 1000,
                backgroundColor: '#e6e6e6',
                padding: '20px',
            }}
        >
            Modal content
        </div>
    </ModalWithTrigger>
);
