import React from 'react';

import {useToggle} from 'utilities/hooks/useToggle';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Modal, {IModalProps} from 'components/Modal/Modal';

import cx from './ModalWithTrigger.scss';

export interface IModalWithTriggerProps
    extends IWithQaAttributes,
        Omit<IModalProps, 'isVisible'> {
    isVisible?: boolean;
    triggerClassName?: string;
    triggerText?: string;
    renderTriggerNode?: (triggerProps: {
        onClick: () => void;
        isVisible: boolean;
    }) => React.ReactNode;
}

const ModalWithTrigger = (props: IModalWithTriggerProps) => {
    const {
        triggerClassName,
        triggerText,
        children,
        renderTriggerNode,
        ...otherProps
    } = props;

    const [isVisible, toggleVisibility] = useToggle(false);

    const handleClose = () => {
        toggleVisibility();
    };

    const handleTriggerClick = () => {
        toggleVisibility();
    };

    return (
        <>
            <Modal isVisible={isVisible} onClose={handleClose} {...otherProps}>
                {children}
            </Modal>
            {renderTriggerNode ? (
                renderTriggerNode({
                    onClick: handleTriggerClick,
                    isVisible,
                })
            ) : (
                <button
                    className={cx('trigger', triggerClassName)}
                    type="button"
                    onClick={handleTriggerClick}
                    {...prepareQaAttributes(props)}
                >
                    {triggerText}
                </button>
            )}
        </>
    );
};

ModalWithTrigger.defaultProps = {
    preventBodyScroll: true,
};

export default ModalWithTrigger;
