import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {NAVIGATION_ITEMS_MOCK} from 'constants/mocks/navigation';

import {TStorybookFunctionComponent} from 'storybook/types';

import Navigation from './Navigation';

export default {
    title: 'Example/Navigation',
    component: Navigation,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Navigation items={NAVIGATION_ITEMS_MOCK} />
);

Simple.parameters = {
    info: {
        comment: 'Простой блок навигации',
    },
};

export const Expandable: TStorybookFunctionComponent = () => (
    <Navigation items={NAVIGATION_ITEMS_MOCK} expandable />
);

Expandable.parameters = {
    info: {
        comment: 'Разворачивающийся блок навигации',
    },
};
