import React from 'react';

import TTripListItem from 'types/trips/TTripListItem/TTripListItem';
import {IWithClassName} from 'types/withClassName';

import {getTripOrOrderUrl} from 'projects/account/utilities/urls/getTripOrOrderUrl';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import TripImage from 'projects/trips/components/TripImage/TripImage';
import Text from 'components/Text/Text';
import Link from 'components/Link/Link';

interface IActiveTripsListItemProps extends IWithClassName, IWithQaAttributes {
    trip: TTripListItem;
    onClick?(): void;
}

const ActiveTripsListItem: React.FC<IActiveTripsListItemProps> = props => {
    const {className, trip, onClick} = props;

    return (
        <Link
            className={className}
            to={getTripOrOrderUrl(trip)}
            onClick={onClick}
            {...prepareQaAttributes(props)}
        >
            <Flex between={3} inline alignItems="center" nowrap>
                <TripImage
                    src={trip.image}
                    {...prepareQaAttributes({parent: props, current: 'image'})}
                />
                <Text
                    size="m"
                    overflow="ellipsis"
                    {...prepareQaAttributes({parent: props, current: 'title'})}
                >
                    {trip.title}
                </Text>
            </Flex>
        </Link>
    );
};

export default ActiveTripsListItem;
