import {Meta} from '@storybook/react/types-6-0';
import {noop} from 'lodash';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Card from 'components/Card/Card';

import NoResultsAfterFiltration from './NoResultsAfterFiltration';

export default {
    title: 'Example/NoResultsAfterFiltration',
    component: NoResultsAfterFiltration,
} as Meta;

const FILTERS = [
    {
        text: 'без пересадок',
        handler: noop,
    },
    {
        text: 'бесплатные',
        handler: noop,
    },
    {
        text: 'шведский стол на борту',
        handler: noop,
    },
];

export const Filters: TStorybookFunctionComponent = () => (
    <Box between="5">
        <Card style={{height: '480px'}}>
            <NoResultsAfterFiltration
                title="Нет билетов подходящих под ваши пожелания"
                subtitle="Давайте будем проще и сбросим один из фильтров"
                filters={FILTERS}
            />
        </Card>
    </Box>
);

export const Reset: TStorybookFunctionComponent = () => (
    <Box between="5">
        <Card style={{height: '480px'}}>
            <NoResultsAfterFiltration
                title="Нет билетов подходящих под ваши пожелания"
                subtitle="Давайте будем проще и сбросим один из фильтров"
                onReset={noop}
            />
        </Card>
    </Box>
);
