import {ReactElement, useEffect, useState} from 'react';

export interface NoSsrProps {
    fallback?: ReactElement | null;
    children: NonNullable<ReactElement>;
}

export function NoSsr({children, fallback = null}: NoSsrProps) {
    const [visible, setVisible] = useState(false);

    useEffect(() => setVisible(true), []);

    return visible ? children : fallback;
}
