import {ReactNode, Component} from 'react';
import Helmet from 'react-helmet';

import {ECommonGoal} from 'utilities/metrika/types/goals/common';

import {reachGoal} from 'utilities/metrika';

import * as i18nBlock from 'i18n/common-notFoundPage';

import NotFoundStatus from './components/NotFoundStatus/NotFoundStatus';

interface INotFoundWrapperProps {
    children: ReactNode;
}

class NotFoundWrapper extends Component<INotFoundWrapperProps> {
    componentDidMount(): void {
        reachGoal(ECommonGoal.PAGE_404_SHOW);
    }

    render(): ReactNode {
        return (
            <NotFoundStatus>
                <Helmet>
                    <title>{i18nBlock.metaDashTitle()}</title>
                </Helmet>

                {this.props.children}
            </NotFoundStatus>
        );
    }
}

export default NotFoundWrapper;
