import {ReactNode, Component} from 'react';
import {Route, RouteComponentProps} from 'react-router-dom';

const NOT_FOUND_STATUS_CODE = 404;

class NotFoundStatus extends Component {
    private routeRenderer = ({
        staticContext,
    }: RouteComponentProps): ReactNode => {
        if (staticContext) {
            staticContext.statusCode = NOT_FOUND_STATUS_CODE;
        }

        return this.props.children;
    };

    render(): ReactNode {
        return <Route render={this.routeRenderer} />;
    }
}

export default NotFoundStatus;
