import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Box, {IBoxProps} from 'components/Box/Box';
import Intersperse from 'components/Intersperse/Intersperse';
import Separator from 'components/Separator/Separator';

import cx from './NotificationBanner.scss';

interface INotificationBannerProps
    extends IWithClassName,
        IWithQaAttributes,
        Pick<IBoxProps, 'below' | 'above'> {}

const NotificationBanner: React.FC<INotificationBannerProps> = props => {
    const {className, children, above, below} = props;

    const deviceType = useDeviceType();

    return (
        <Box
            className={cx('root', className)}
            x={deviceType.isDesktop ? 8 : 4}
            y={deviceType.isDesktop ? 4 : 3}
            above={above}
            below={below}
            {...prepareQaAttributes(props)}
        >
            <div className={cx('wrapper')}>
                <Intersperse separator={<Separator margin={3} />}>
                    {children}
                </Intersperse>
            </div>
        </Box>
    );
};

export default NotificationBanner;
