import {FunctionComponent, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './NotificationDot.scss';

interface INotificationDotProps extends IWithClassName {
    children: ReactNode;
    size: 's' | 'm' | 'l';
    dotVisible: boolean;
}

/**
 * Компонент заточен только под белый фон из-за выреза в углу иконки
 *
 * Потребности в работе на других фонах нет, но если появится, то нужна доработка.
 * Пробовались варианты с clip-path (svg, css), но везде была проблема с масштабированием, чтобы работало для любых размеров
 */
const NotificationDot: FunctionComponent<INotificationDotProps> = ({
    className,
    children,
    size,
    dotVisible,
}) => {
    return (
        <div className={cx(className, 'root')}>
            {children}
            {dotVisible && <div className={cx('dot', `dot_size_${size}`)} />}
        </div>
    );
};

export default NotificationDot;
