import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import OrderActions, {EOrderActionsSource} from './OrderActions';

export default {
    title: 'Example/OrderActions',
    component: OrderActions,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <OrderActions
        source={EOrderActionsSource.ORDER_PAGE}
        orderDetails={{
            url: '#',
        }}
        print={{
            title: 'Распечатать',
            url: '#',
            onClick: (): void => {
                console.log('print');
            },
        }}
        download={{
            title: 'Скачать',
            url: '#',
            fileName: 'Заказ тут',
            onClick: (): void => {
                console.log('download');
            },
        }}
        cancel={{
            title: 'Отменить',
            isDisabled: true,
            tooltipTitle: 'Подожди',
            onClick: (): void => {
                console.log('cancel');
            },
        }}
        more={{
            innerRef: {current: null},
            onClick: (): void => {
                console.log('more');
            },
        }}
    />
);

export const PartialActions: TStorybookFunctionComponent = () => (
    <OrderActions
        source={EOrderActionsSource.ORDER_PAGE}
        orderDetails={{
            url: '#',
        }}
        print={{
            title: 'Распечатать',
            url: '#',
            onClick: (): void => {
                console.log('print');
            },
        }}
        download={{
            title: 'Скачать',
            url: '#',
            fileName: 'Заказ тут',
            onClick: (): void => {
                console.log('download');
            },
        }}
    />
);
