import EDisplayOrderState from 'types/common/orders/EDisplayOrderState';
import EOrderStatusType from 'projects/account/components/OrderStatus/types/EOrderStatusType';

export default function getOrderStatusByDisplayState(
    displayState: EDisplayOrderState,
): EOrderStatusType {
    switch (displayState) {
        case EDisplayOrderState.FULFILLED:
            return EOrderStatusType.DONE;

        case EDisplayOrderState.CANCELLED:
        case EDisplayOrderState.REFUNDED:
            return EOrderStatusType.CANCELLED;

        case EDisplayOrderState.IN_PROGRESS:
        case EDisplayOrderState.AWAITS_PAYMENT:
        default:
            return EOrderStatusType.PROGRESS;
    }
}
