import {EProjectName} from 'constants/common';

import {EOrderApiType} from 'server/api/OrdersAPI/enums/types';

export default function getProjectNameByOrderType(
    type: EOrderApiType,
): EProjectName.TRAINS | EProjectName.HOTELS | EProjectName.AVIA {
    switch (type) {
        case EOrderApiType.TRAIN: {
            return EProjectName.TRAINS;
        }

        case EOrderApiType.HOTEL: {
            return EProjectName.HOTELS;
        }

        case EOrderApiType.AVIA: {
            return EProjectName.AVIA;
        }

        default: {
            throw new Error('Нет такого типа в EProjectName');
        }
    }
}
