import {FunctionComponent, useState, useEffect} from 'react';
import ReactDOM from 'react-dom';

import {useLayer} from 'utilities/hooks/useLayer';

import {usePreventScroll} from '@yandex-lego/components/usePreventScroll';
import {MODAL_LAYER_MULTIPLIER} from 'components/Modal/Modal';

import cx from './Overlay.scss';

interface IOverlayProps {
    isVisible?: boolean;
    onClick?: () => void;
}

const Overlay: FunctionComponent<IOverlayProps> = ({isVisible, onClick}) => {
    const newLayer = useLayer();
    const [canRender, setCanRender] = useState(false);

    usePreventScroll({enabled: isVisible});

    useEffect(() => setCanRender(true), []);

    if (!canRender) {
        return null;
    }

    return ReactDOM.createPortal(
        <div
            className={cx('root', isVisible && 'root_visible')}
            onClick={onClick}
            style={{
                zIndex: newLayer * MODAL_LAYER_MULTIPLIER,
            }}
        />,
        document.body,
    );
};

export default Overlay;
