import {FC, memo} from 'react';

import {URLs} from 'constants/urls';
import {EProjectName} from 'constants/common';

import {useIsOnPage} from 'utilities/hooks/useIsOnPage';

import * as i18nBlock from 'i18n/common-pageLoading';

import Spinner from 'components/Spinner/Spinner';
import LayoutDefault from 'components/Layouts/LayoutDefault/LayoutDefault';

import {usePlatform} from 'contexts/PlatformContext';

import cx from './PageLoading.scss';

const PageLoading: FC = () => {
    const showTabBar = useIsOnPage([
        URLs[EProjectName.INDEX],
        URLs[EProjectName.AVIA],
        URLs[EProjectName.TRAINS],
        URLs[EProjectName.HOTELS],
        URLs[EProjectName.BUSES],
        URLs[EProjectName.FAVORITES],
        URLs.accountTrips,
    ]);
    const {isWeb} = usePlatform();

    return (
        <LayoutDefault
            showHeader={isWeb}
            showFooter={isWeb}
            showTabBar={showTabBar}
        >
            <div className={cx('root')}>
                <div>
                    <Spinner />
                    <div className={cx('description')}>
                        {i18nBlock.loading()}
                    </div>
                </div>
            </div>
        </LayoutDefault>
    );
};

export default memo(PageLoading);
