import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Pagintaion from './Pagination';

export default {
    title: 'Example/Pagination',
    component: Pagintaion,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [page, setPage] = useState(1);

    return (
        <Pagintaion
            page={page}
            itemsCount={90}
            itemsPerPage={15}
            onPageChange={setPage}
        />
    );
};

export const WithSeparators: TStorybookFunctionComponent = () => {
    const [page, setPage] = useState(1);

    return (
        <Pagintaion
            page={page}
            itemsCount={900}
            itemsPerPage={5}
            onPageChange={setPage}
        />
    );
};
