export function validatePageNumber(
    rawNumber: unknown,
    minPageNumber: number,
    maxPageNumber: number,
): number {
    if (!rawNumber) {
        return minPageNumber;
    }

    const pageNumber = Number.isNaN(Number(rawNumber))
        ? minPageNumber
        : Number(rawNumber);

    return Math.min(Math.max(1, pageNumber), maxPageNumber);
}
