import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import PartialPrice from './PartialPrice';

export default {
    title: 'Example/PartialPrice',
    component: PartialPrice,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <PartialPrice
        price={{value: 10, currency: CurrencyType.RUB}}
        totalPrice={{value: 100, currency: CurrencyType.RUB}}
    />
);

Simple.parameters = {
    info: {
        title: 'Отображение части цены из какой-то общей',
    },
};

export const Full: TStorybookFunctionComponent = () => (
    <PartialPrice
        price={{value: 100, currency: CurrencyType.RUB}}
        totalPrice={{value: 100, currency: CurrencyType.RUB}}
    />
);

Full.parameters = {
    info: {
        title: 'Отображение части цены из какой-то общей',
    },
};

export const NoPartialPrice: TStorybookFunctionComponent = () => (
    <PartialPrice
        price={undefined}
        totalPrice={{value: 100, currency: CurrencyType.RUB}}
    />
);

NoPartialPrice.parameters = {
    info: {
        title: 'Если нет части, то показываем просто общую',
    },
};
