import React from 'react';

import IPartnerRequisites from 'components/PartnersRequisites/types/IPartnerRequisites';
import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Text from 'components/Text/Text';
import Partner from 'components/PartnersRequisites/components/PartnersInfo/components/Partner/Partner';
import Intersperse from 'components/Intersperse/Intersperse';
import Separator from 'components/Separator/Separator';
import Box from 'components/Box/Box';

import cx from './PartnerInfo.scss';

interface IPartnersInfoProps extends IWithClassName, IWithQaAttributes {
    partners: IPartnerRequisites[];
    modalTitle: string;
    modalSubTitle?: string;
}

const PartnersInfo: React.FC<IPartnersInfoProps> = props => {
    const {className, partners, modalTitle, modalSubTitle} = props;
    const deviceType = useDeviceType();

    return (
        <div className={className} {...prepareQaAttributes(props)}>
            <Text
                size={deviceType.isMobile ? 'l' : 'xxl'}
                {...prepareQaAttributes({parent: props, current: 'title'})}
            >
                {modalTitle}
            </Text>
            {modalSubTitle && (
                <Text
                    className={cx('subTitle')}
                    size={deviceType.isMobile ? 's' : 'm'}
                    color="secondary"
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'subTitle',
                    })}
                >
                    {modalSubTitle}
                </Text>
            )}

            <Box above={5}>
                <Intersperse
                    separator={
                        deviceType.isMobile ? (
                            <Separator margin={4} />
                        ) : (
                            <div className={cx('spaceSeparator')} />
                        )
                    }
                >
                    {partners.map(partner => (
                        <Partner
                            key={partner.title}
                            partner={partner}
                            {...prepareQaAttributes({
                                parent: props,
                                current: 'partner',
                                key: partner.title,
                            })}
                        />
                    ))}
                </Intersperse>
            </Box>
        </div>
    );
};

export default PartnersInfo;
