import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {getPhoneUrl} from 'utilities/url/getPhoneUrl';

import cx from './Phone.scss';

interface IPhoneProps extends IWithClassName, IWithQaAttributes {
    phone: string;
}

const Phone: React.FC<IPhoneProps> = props => {
    const {phone, className} = props;

    return (
        <a
            className={cx('phone', className)}
            href={getPhoneUrl(phone)}
            {...prepareQaAttributes(props)}
        >
            {phone}
        </a>
    );
};

export default Phone;
