import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithDataQaAttribute,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Phone from 'components/Phone/Phone';
import Text from 'components/Text/Text';

import cx from './PhoneWithTitle.scss';

interface IPhoneWithTitleProps extends IWithDataQaAttribute, IWithClassName {
    title: string;
    phone: string;
}

const PhoneWithTitle: React.FC<IPhoneWithTitleProps> = props => {
    const {title, phone, className} = props;
    const deviceType = useDeviceType();

    return (
        <div
            className={cx(
                'support',
                deviceMods('support', deviceType),
                className,
            )}
            {...prepareQaAttributes(props)}
        >
            <Text size="s">{title}</Text>
            <Phone phone={phone} className={cx('phone')} />
        </div>
    );
};

export default PhoneWithTitle;
