import * as i18nBlock from 'i18n/components-PlusInfoPopup';
import * as i18nStaticBlock from 'i18n/hotels-seoPage-plusInfo';

import {TLabelDescriptionType} from 'components/PlusInfoPopup/PlusInfoPopup';

const getLabel = (
    labelType?: TLabelDescriptionType,
    plusPoints?: number,
): string => {
    if (plusPoints && plusPoints >= 0) {
        switch (labelType) {
            case 'short':
                return i18nBlock.plusPoints({plusPoints});
            case 'full':
                return i18nBlock.plusPointsFull({plusPoints});
        }
    }

    return i18nStaticBlock.isAvailableTenPercentBadge();
};

export default getLabel;
