import React from 'react';

import {EHotelBadgeType, TBadgeType} from 'types/hotels/offer/IHotelOffer';

import YandexPlusSignColorGradientM from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientM';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';
import YandexPlusHighSignColorGradientM from 'icons/illustrations/YandexPlusHighSignColorGradient/YandexPlusHighSignColorGradientM';
import YandexPlusHighSignColorGradientS from 'icons/illustrations/YandexPlusHighSignColorGradient/YandexPlusHighSignColorGradientS';
import {TIconSize} from 'components/TextWithIcon/TextWithIcon';
import {TSize} from 'components/PlusInfoPopup/PlusInfoPopup';

export const getIconBySizeAndId = (
    size: TSize,
    id?: TBadgeType,
): React.FunctionComponent => {
    if (id === EHotelBadgeType.YANDEX_PLUS_CULTURAL_DREAMS) {
        switch (size) {
            case 's-inset':
                return YandexPlusHighSignColorGradientM;
            case 'm':
                return YandexPlusHighSignColorGradientS;
        }
    }

    switch (size) {
        case 's-inset':
            return YandexPlusSignColorGradientM;
        case 'm':
            return YandexPlusSignColorGradientS;
    }
};

export const getIconSize = (size: TSize): TIconSize => {
    switch (size) {
        case 's-inset':
            return 12;
        case 'm':
            return 16;
    }
};

const S_ICON_SIZES = {
    width: 12,
    height: 12,
};

const M_ICON_SIZES = {
    width: 16,
    height: 16,
};

export const getIconSizes = (
    size: TSize,
    id?: TBadgeType,
): {width?: number; height?: number} => {
    if (id === EHotelBadgeType.YANDEX_PLUS_CULTURAL_DREAMS) {
        switch (size) {
            case 's-inset':
                return {height: 12};
            case 'm':
                return {height: 16};
        }
    }

    switch (size) {
        case 's-inset':
            return S_ICON_SIZES;
        case 'm':
            return M_ICON_SIZES;
    }
};
