import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import PlusLabel from './PlusLabel';

export default {
    title: 'Example/PlusLabel',
    component: PlusLabel,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <PlusLabel count={777} />
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                example: <PlusLabel size="s" count={777} />,
            },
            {
                name: 'm',
                example: <PlusLabel size="m" count={777} />,
            },
        ]}
    />
);

export const Theme: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            {
                name: 'colored',
                props: {theme: 'colored'},
                example: <PlusLabel theme="colored" count={777} />,
            },
            {
                name: 'black',
                props: {theme: 'black'},
                example: <PlusLabel theme="black" count={777} />,
            },
        ]}
    />
);
