import React from 'react';

import {IWithClassName} from 'types/withClassName';

import PlusPoints, {IPlusPointsProps} from 'components/PlusPoints/PlusPoints';

import cx from './PlusLabel.scss';

export interface IPlusLabelProps extends IPlusPointsProps, IWithClassName {
    size?: 's' | 'm';
}

const PlusLabel = React.forwardRef<HTMLDivElement, IPlusLabelProps>(
    ({className, size = 's', theme, count}, ref) => {
        return (
            <PlusPoints
                ref={ref}
                className={cx('root', `root_size_${size}`, className)}
                size={size}
                theme={theme}
                count={count}
            />
        );
    },
);

PlusLabel.displayName = 'PlusLabel';

export default React.memo(PlusLabel);
