import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EYandexPlusApplicationMode} from 'types/hotels/offer/IHotelOffer';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import PlusModeBlock from './PlusModeBlock';

export default {
    title: 'Example/PlusModeBlock',
    component: PlusModeBlock,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [value, setValue] = useState(EYandexPlusApplicationMode.TOPUP);

    return (
        <PlusModeBlock
            plusMode={value}
            topupPlusPoints={100}
            withdrawPlusPoints={1000}
            priceAfterPlusWithdraw={{
                value: 6000,
                currency: CurrencyType.RUB,
            }}
            onChangePlusMode={setValue}
        />
    );
};
