import React from 'react';

import {IWithClassName} from 'types/withClassName';

import YandexPlusSignBws from 'icons/illustrations/YandexPlusSignBw/YandexPlusSignBwS';
import YandexPlusSignBlueGradientS from 'icons/illustrations/YandexPlusSignBlueGradient/YandexPlusSignBlueGradientS';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';
import YandexPlusSignDisabledS from 'icons/illustrations/YandexPlusSignDisabled/YandexPlusSignDisabledS';
import Text, {TTextColor, TTextWeight} from 'components/Text/Text';

import cx from './PlusPoints.scss';

function getTextColorByTheme(
    theme: IPlusPointsProps['theme'],
): TTextColor | undefined {
    if (theme === 'colored') return 'plus-cropped';
    if (theme === 'disabled') return 'secondary';
}

export interface IPlusPointsProps extends IWithClassName {
    theme?: 'colored' | 'black' | 'semi-colored' | 'disabled';
    weight?: TTextWeight;
    size?: 's' | 'm';
    count: number | string;
}

const PlusPoints = React.forwardRef<HTMLDivElement, IPlusPointsProps>(
    (
        {className, theme = 'colored', size = 'm', weight = 'normal', count},
        ref,
    ) => {
        return (
            <div
                ref={ref}
                className={cx('root', `root_size_${size}`, className)}
            >
                {theme === 'disabled' && (
                    <YandexPlusSignDisabledS className={cx('icon')} />
                )}
                {theme === 'colored' && (
                    <YandexPlusSignBlueGradientS className={cx('icon')} />
                )}
                {theme === 'semi-colored' && (
                    <YandexPlusSignColorGradientS className={cx('icon')} />
                )}
                {theme === 'black' && (
                    <YandexPlusSignBws className={cx('icon')} />
                )}
                <Text
                    className={cx('count')}
                    color={getTextColorByTheme(theme)}
                    weight={weight}
                    size="inherit"
                >
                    {count}
                </Text>
            </div>
        );
    },
);

PlusPoints.displayName = 'PlusPoints';

export default PlusPoints;
