import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Price from './Price';

export default {
    title: 'Example/Price',
    component: Price,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <p>
            <Price value={12345678} currency={CurrencyType.RUB} />
        </p>
        <p>
            <Price value={12345678} currency={CurrencyType.USD} />
        </p>
        <p>
            <Price value={12345678} currency={CurrencyType.RUB} isFrom />
        </p>
        <p>
            <Price value={12345678} currency={CurrencyType.RUB} isRound />
        </p>
        <p>
            <Price value={12345678} currency={CurrencyType.RUB} isRoughly />
        </p>
    </>
);
Simple.parameters = {
    info: {
        title: 'Компонент для форматирования и вывода цен',
    },
};
