import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';
import {useCurrencyConverter} from 'utilities/hooks/useCurrencyConverter';
import {IDeprecatedPrice} from 'utilities/currency/IDeprecatedPrice';

import {TTextColor} from 'components/Text/Text';
import PriceWithoutConvertor from 'components/PriceWithoutConvertor/PriceWithoutConvertor';

export interface IPriceProps
    extends IDeprecatedPrice,
        IWithClassName,
        IWithQaAttributes {
    /** Цвет */
    color?: TTextColor;

    /** Показывать знак валюты */
    isCurrencyShown?: boolean;

    /** Префикс "от" */
    isFrom?: boolean;

    /** Префикс "до" */
    isUpTo?: boolean;

    /** Не показывать цифры после запятой */
    isRound?: boolean;

    /** Примерная цена */
    isRoughly?: boolean;

    /** Префикс к цене */
    prefix?: string;
    prefixDelimiter?: string;

    /**
     * Нужно ли конвертировать валюту к национальной
     * Конвертация возможна только в случае наличия соответствующих данных
     */
    withConversion?: boolean;

    /** Постфикс к цене */
    postfix?: string;
}

const Price: React.FC<IPriceProps> = props => {
    const priceConverter = useCurrencyConverter();

    return <PriceWithoutConvertor priceConverter={priceConverter} {...props} />;
};

export default Price;
