import React, {useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';

import {CurrencyType} from 'utilities/currency/CurrencyType';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import InputRange from 'components/InputRange/InputRange';
import Price from 'components/Price/Price';
import Box from 'components/Box/Box';

import cx from './PriceFilter.scss';

interface IPriceFilterProps extends IWithClassName {
    values: [number, number];
    rangeValues: [number, number];
    onChange(value: [number, number]): void;
}

const PriceFilter: React.FC<IPriceFilterProps> = props => {
    const {className, values, rangeValues, onChange} = props;

    const deviceType = useDeviceType();

    const renderTooltip = useCallback(
        ({value}: {value: number}): React.ReactNode => {
            return <Price value={value} currency={CurrencyType.RUB} isRound />;
        },
        [],
    );

    return (
        <Box className={cx('root', deviceMods('root', deviceType), className)}>
            <InputRange
                values={values}
                rangeValues={rangeValues}
                size={deviceType.isMobile ? 'm' : 's'}
                renderHandleTooltip={renderTooltip}
                onChange={onChange as (value: Readonly<number[]>) => void}
            />
        </Box>
    );
};

export default React.memo(PriceFilter);
