import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import ProgressBar from './ProgressBar';

export default {
    title: 'Example/ProgressBar',
    component: ProgressBar,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <ProgressBar current={40} all={100} visible>
            Загружено 40 котиков из 🤍
        </ProgressBar>
    );
};

export const Thin: TStorybookFunctionComponent = () => {
    return <ProgressBar current={40} all={100} visible type="thin" />;
};

export const Fixed: TStorybookFunctionComponent = () => {
    return <ProgressBar current={40} all={100} visible fixed />;
};
