import React from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import cx from './ProgressBar.scss';

export interface IProgressBarProps {
    current: number;
    all: number;
    visible: boolean;
    fixed?: boolean;
    contentClassName?: string;
    type?: 'full' | 'thin';
}

const ProgressBar: React.FC<IProgressBarProps> = ({
    all,
    current,
    fixed = true,
    visible,
    contentClassName,
    type = 'full',
    children,
}) => {
    const deviceType = useDeviceType();
    /*
     * когда на тачах зависает на 54/55, не видно, что прогресс не закончен, поэтому
     * не двигаем его дальше 95%, при 100% он сразу пропадает, поэтому нет смысла
     * добавлять кейс на 100%
     */
    const maxPercentValue =
        type === 'full' || (type === 'thin' && !deviceType.isMobile) ? 1 : 0.95;
    const percent = Math.min(maxPercentValue, Math.max(0, current / all));

    return (
        <div
            className={cx(
                'root',
                visible && 'root_visible',
                fixed && 'root_fixed',
                `root_${type}`,
            )}
        >
            <div
                className={cx('progress', `progress_${type}`)}
                style={{width: `${percent * 100}%`}}
            />
            {type === 'full' && (
                <div
                    className={cx(
                        'content',
                        deviceMods('content', deviceType),
                        contentClassName,
                    )}
                >
                    {children}
                </div>
            )}
        </div>
    );
};

export default ProgressBar;
