import React, {ChangeEventHandler, FC, ReactNode, useCallback} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './RadioButtonSlideOption.scss';

export interface IRadioButtonSlideOptionProps
    extends IWithClassName,
        IWithQaAttributes {
    value: string;
    children: ReactNode;
    name?: string;
    id?: string;
    checked?: boolean;
    disabled?: boolean;
    className?: string;
    width?: number | `${number}%`;
    onClick?(value: string): void;
}

const RadioButtonSlideOption: FC<IRadioButtonSlideOptionProps> = ({
    value,
    checked,
    onClick,
    className,
    disabled,
    width = 0,
    children,
    ...rest
}) => {
    const handleOnChange = useCallback<ChangeEventHandler<HTMLInputElement>>(
        event => {
            onClick?.(event.target.value);
        },
        [onClick],
    );

    return (
        <label
            className={cx('label', className, {disabled, checked})}
            style={{width}}
            {...prepareQaAttributes(rest)}
        >
            <input
                type="radio"
                autoComplete="off"
                className={cx('input')}
                value={value}
                checked={checked}
                disabled={disabled}
                onChange={handleOnChange}
            />
            <div className={cx('content')}>{children}</div>
        </label>
    );
};

export default React.memo(RadioButtonSlideOption);
