import {compose, composeU} from '@bem-react/core';

import {
    Radiobox as LegoDesktopRadiobox,
    RadioboxProps as ILegoRadioboxProps,
    withThemeNormal as withLegoThemeNormal,
} from '@yandex-lego/components/Radiobox/desktop';

/** _device */
import {withDeviceTouch} from '../_device/Radiobox_device_touch';
/** _size */
import {withSizeM} from '../_size/Radiobox_size_m';
import {withSizeS} from '../_size/Radiobox_size_s';
/** _theme */
import {withThemeNormal} from '../_theme/Radiobox_theme_normal';
import {cnRadiobox} from '../cnRadiobox';

export interface IRadioboxProps extends Omit<ILegoRadioboxProps, 'value'> {
    value?: ILegoRadioboxProps['value'];
    device?: 'touch' | 'desktop';
}

const YTLegoRadioboxWrapper = (props: ILegoRadioboxProps) => (
    <LegoDesktopRadiobox
        {...props}
        className={cnRadiobox(null, [props.className])}
    />
);

export const RadioboxPresenter = compose(
    composeU(withSizeM, withSizeS),
    composeU(withThemeNormal),
    withLegoThemeNormal,
    composeU(withDeviceTouch),
)(YTLegoRadioboxWrapper);
