import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import Text from 'components/Text/Text';
import Heading from 'components/Heading/Heading';

import Raskrivashka from './Raskrivashka';

import cx from './Raskrivashka.stories.scss';

export default {
    title: 'Example/Raskrivashka',
    component: Raskrivashka,
} as Meta;

export const Themes: TStorybookFunctionComponent = () => (
    <Box between="4">
        <Heading level="3">Default</Heading>
        <Raskrivashka label="Посмотри что внутри" contentIsInvolved>
            Котята!!!
        </Raskrivashka>
        <Heading level="3">Clear</Heading>
        <Raskrivashka
            theme="clear"
            label={
                <Text color="secondary" size="m">
                    Внутри важная информация
                </Text>
            }
            contentIsInvolved={false}
            iconClassName={cx('icon')}
        >
            <Box y="2">
                <Text color="secondary" size="m">
                    Котят нужно гладить и не ругать!!!
                </Text>
            </Box>
        </Raskrivashka>
    </Box>
);
