import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import Rating from './Rating';

export default {
    title: 'Example/Rating',
    component: Rating,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Box between={2} inline>
        <Rating rating={4.2} size="m" />
        <Rating rating={3} size="m" />
        <Rating rating={1.5} size="m" />
        <Rating rating={0.2} size="m" />
    </Box>
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {name: 's', example: <Rating rating={4.2} size="s" />},
            {name: 'm', example: <Rating rating={4.2} size="m" />},
            {name: 'l', example: <Rating rating={4.2} size="l" />},
        ]}
    />
);
