import {useState} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Flex from 'components/Flex/Flex';

import RatingStars from './RatingStars';

export default {
    title: 'Example/RatingStars',
    component: RatingStars,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    const [selectedStar, setSelectedStar] = useState(0);

    return (
        <Flex flexDirection="column" between={4}>
            <RatingStars onClick={setSelectedStar} selected={selectedStar} />
            <RatingStars
                onClick={setSelectedStar}
                selected={selectedStar}
                count={10}
            />
        </Flex>
    );
};
