import React, {useCallback, useMemo, useState} from 'react';
import {times} from 'lodash';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import RatingStar from './components/RatingStar/RatingStar';

import cx from './RatingStars.scss';

const DEFAULT_STARS_COUNT = 5;
const UNSET_STAR = 0;

interface IRatingStarsProps extends IWithClassName {
    count?: number;
    selected?: number;
    onClick?: (index: number) => void;
}

const RatingStars: React.FC<IRatingStarsProps> = ({
    className,
    count = DEFAULT_STARS_COUNT,
    selected = UNSET_STAR,
    onClick,
}) => {
    const [hoveredIndex, setHoveredIndex] = useState(UNSET_STAR);
    const stars = useMemo(() => times(count).map(i => i + 1), [count]);

    const handleMouseEnter = useCallback(
        index => {
            setHoveredIndex(index);
        },
        [setHoveredIndex],
    );
    const handleMouseLeave = useCallback(() => {
        setHoveredIndex(UNSET_STAR);
    }, [setHoveredIndex]);

    return (
        <Flex className={cx('root', className)} flexDirection="row">
            {stars.map(i => (
                <RatingStar
                    key={i}
                    index={i}
                    isHovered={hoveredIndex >= i}
                    isSelected={selected >= i}
                    onMouseEnter={handleMouseEnter}
                    onMouseLeave={handleMouseLeave}
                    onClick={onClick}
                />
            ))}
        </Flex>
    );
};

export default RatingStars;
