import {Component, ReactNode} from 'react';
import {Redirect, Route, RouteComponentProps} from 'react-router-dom';

import {ERedirectStatusCodes} from 'constants/redirectStatusCodes';

interface IRedirectWithStatus {
    to: string;
    from?: string;
    statusCode?: ERedirectStatusCodes;
}

export default class RedirectWithStatus extends Component<IRedirectWithStatus> {
    static readonly defaultProps: Partial<IRedirectWithStatus> = {
        statusCode: ERedirectStatusCodes.PERMANENTLY,
    };

    private routeRenderer = ({
        staticContext,
    }: RouteComponentProps): ReactNode => {
        const {statusCode, from, to} = this.props;

        if (staticContext) {
            staticContext.statusCode = statusCode;
        }

        return <Redirect from={from} to={to} />;
    };

    render(): ReactNode {
        return <Route path={this.props.from} render={this.routeRenderer} />;
    }
}
