import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {ISimpleTextReview} from 'types/common/ISimpleTextReview';

import Reviews from 'components/Reviews/Reviews';

export default {
    title: 'Trains/Reviews',
    component: Reviews,
} as Meta;

const reviews: ISimpleTextReview[] = [
    {
        rating: 3,
        updatedAt: 'вчера',
        title: 'Моосква - Петушки',
        text: 'Много текста о том какая классная была поездка и о том как мне всё понравилоось за исключением постельнго белья и проводницы',
    },
    {
        rating: 5,
        updatedAt: 'позавчера',
        title: 'Петушки - Москва',
        text: 'Много текста о том какая классная была поездка и о том как мне всё понравилоось за исключением постельнго белья и проводницы',
    },
];

export const Simple: TStorybookFunctionComponent = () => (
    <Reviews reviews={reviews} />
);
