import React, {ReactNode, MouseEventHandler, FocusEventHandler} from 'react';
import classNames from 'classnames';

import {IWithClassName} from 'types/withClassName';

import {RoundButtonPresenter} from './controls/RoundButtonPresenter';

export interface IRoundButtonProps extends IWithClassName {
    /**
     * Тема кнопки
     *
     * @default 'white'
     */
    theme?: 'white' | 'dark';

    children?: ReactNode;

    type?: 'button' | 'submit' | 'reset';

    icon?: ReactNode;

    disabled?: boolean;

    /**
     * Размер кнопки
     *
     * @default 'm'
     */
    size?: 's' | 'm' | 'l';

    innerRef?: (node: HTMLElement | null) => void;

    tabIndex?: number;

    onClick?: MouseEventHandler<HTMLElement>;

    onMouseEnter?: MouseEventHandler<HTMLElement>;

    onMouseLeave?: MouseEventHandler<HTMLElement>;

    onMouseOver?: MouseEventHandler<HTMLElement>;

    onFocus?: FocusEventHandler<HTMLElement>;

    onBlur?: FocusEventHandler<HTMLElement>;
}

export default function RoundButton({
    size = 'm',
    theme = 'white',
    children,
    icon,
    type,
    disabled,
    className,
    innerRef,
    tabIndex = 0,
    onClick,
    onBlur,
    onFocus,
    onMouseEnter,
    onMouseLeave,
    onMouseOver,
}: IRoundButtonProps) {
    const renderIcon = React.useCallback(
        (cn: string) => (
            <div className={classNames(cn, 'YTRoundButton-IconWrapper')}>
                {icon}
            </div>
        ),
        [icon],
    );

    const commonProps = {
        innerRef,
        children,
        size,
        icon: icon ? renderIcon : undefined,
        className,
        view: 'default' as 'default',
        theme,
        type,
        onClick,
        onBlur,
        onFocus,
        onMouseEnter,
        onMouseLeave,
        onMouseOver,
        tabIndex,
        disabled,
    };

    return <RoundButtonPresenter {...commonProps} />;
}
